/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import org.compiere.model.MClientInfo;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MSchedule;
import org.compiere.model.MScheduler;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MSchedulerTest
extends AbstractTestCase {
    @Test
    public void testCronSchedulingPatternWithTimeZone() {
        MSchedule schedule = null;
        MClientInfo clientInfo = MClientInfo.getCopy((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), null);
        String currentTimeZone = clientInfo.getTimeZone();
        MOrgInfo orgInfo = MOrgInfo.getCopy((Properties)Env.getCtx(), (int)this.getAD_Org_ID(), null);
        String currentTimeZoneOrg = orgInfo.getTimeZone();
        try {
            schedule = new MSchedule(Env.getCtx(), 0, null);
            schedule.setName("Every Day at 5 pm Test");
            schedule.setScheduleType("C");
            schedule.setIsSystemSchedule(false);
            schedule.setCronPattern("0 17 * * *");
            schedule.saveCrossTenantSafeEx();
            TimeZone tz1 = TimeZone.getDefault();
            Calendar cal1 = Calendar.getInstance();
            cal1.setTimeZone(tz1);
            cal1.setTimeInMillis(System.currentTimeMillis());
            int hour = cal1.get(11);
            if (hour >= 17) {
                cal1.add(5, 1);
            }
            cal1.set(11, 17);
            cal1.set(12, 0);
            cal1.set(13, 0);
            cal1.set(14, 0);
            String[] ids = TimeZone.getAvailableIDs(tz1.getRawOffset() + 0x6DDD00);
            TimeZone tz2 = TimeZone.getTimeZone(ids[0]);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTimeZone(tz2);
            cal2.setTimeInMillis(System.currentTimeMillis());
            hour = cal2.get(11);
            if (hour >= 17) {
                cal2.add(5, 1);
            }
            cal2.set(11, 17);
            cal2.set(12, 0);
            cal2.set(13, 0);
            cal2.set(14, 0);
            ids = TimeZone.getAvailableIDs(tz1.getRawOffset() + 10800000);
            TimeZone tz3 = TimeZone.getTimeZone(ids[0]);
            Calendar cal3 = Calendar.getInstance();
            cal3.setTimeZone(tz3);
            cal3.setTimeInMillis(System.currentTimeMillis());
            hour = cal3.get(11);
            if (hour >= 17) {
                cal3.add(5, 1);
            }
            cal3.set(11, 17);
            cal3.set(12, 0);
            cal3.set(13, 0);
            cal3.set(14, 0);
            DateTimeFormatter formatter1 = DateTimeFormatter.ISO_ZONED_DATE_TIME;
            formatter1 = formatter1.withZone(tz1.toZoneId());
            DateTimeFormatter formatter2 = DateTimeFormatter.ISO_ZONED_DATE_TIME;
            formatter2 = formatter2.withZone(tz2.toZoneId());
            DateTimeFormatter formatter3 = DateTimeFormatter.ISO_ZONED_DATE_TIME;
            formatter3 = formatter3.withZone(tz3.toZoneId());
            if (!Util.isEmpty((String)currentTimeZone, (boolean)true)) {
                clientInfo.setTimeZone(null);
                clientInfo.saveEx();
                CacheMgt.get().reset();
            }
            if (!Util.isEmpty((String)currentTimeZoneOrg, (boolean)true)) {
                orgInfo.setTimeZone(null);
                orgInfo.saveEx();
                CacheMgt.get().reset();
            }
            MScheduler scheduler1 = new MScheduler(Env.getCtx(), 0, this.getTrxName());
            scheduler1.setAD_Process_ID(121);
            scheduler1.setAD_Schedule_ID(schedule.get_ID());
            scheduler1.setName("Cron Scheduler Test 1");
            scheduler1.setSupervisor_ID(100);
            scheduler1.saveEx();
            Timestamp ts1 = scheduler1.getDateNextRun();
            Assertions.assertEquals((Object)formatter1.format(cal1.getTime().toInstant()), (Object)formatter1.format(ts1.toInstant()), (String)"Un-expected date next run");
            Assertions.assertFalse((cal2.getTimeInMillis() == ts1.getTime() ? 1 : 0) != 0, (String)"Un-expected date next run");
            clientInfo.setTimeZone(tz2.toZoneId().getId());
            clientInfo.saveEx();
            CacheMgt.get().reset();
            MScheduler scheduler2 = new MScheduler(Env.getCtx(), 0, this.getTrxName());
            scheduler2.setAD_Process_ID(121);
            scheduler2.setAD_Schedule_ID(schedule.get_ID());
            scheduler2.setName("Cron Scheduler Test 2");
            scheduler2.setSupervisor_ID(100);
            scheduler2.saveEx();
            Timestamp ts2 = scheduler2.getDateNextRun();
            Assertions.assertEquals((Object)formatter2.format(cal2.getTime().toInstant()), (Object)formatter2.format(ts2.toInstant()), (String)"Un-expected date next run");
            Assertions.assertFalse((cal1.getTimeInMillis() == ts2.getTime() ? 1 : 0) != 0, (String)"Un-expected date next run");
            orgInfo.setTimeZone(tz3.toZoneId().getId());
            orgInfo.saveEx();
            CacheMgt.get().reset();
            MScheduler scheduler3 = new MScheduler(Env.getCtx(), 0, this.getTrxName());
            scheduler3.setAD_Process_ID(121);
            scheduler3.setAD_Schedule_ID(schedule.get_ID());
            scheduler3.setName("Cron Scheduler Test 3");
            scheduler3.setSupervisor_ID(100);
            scheduler3.saveEx();
            Timestamp ts3 = scheduler3.getDateNextRun();
            Assertions.assertEquals((Object)formatter3.format(cal3.getTime().toInstant()), (Object)formatter3.format(ts3.toInstant()), (String)"Un-expected date next run");
            Assertions.assertFalse((cal1.getTimeInMillis() == ts3.getTime() ? 1 : 0) != 0, (String)"Un-expected date next run");
        }
        finally {
            this.rollback();
            if (schedule != null && schedule.get_ID() > 0) {
                schedule.deleteEx(true);
            }
            clientInfo.setTimeZone(currentTimeZone);
            if (clientInfo.is_Changed()) {
                clientInfo.saveEx();
                CacheMgt.get().reset();
            }
            orgInfo.setTimeZone(currentTimeZoneOrg);
            if (orgInfo.is_Changed()) {
                orgInfo.saveEx();
                CacheMgt.get().reset();
            }
        }
    }
}

